// @name "Common (04.09.2013)"
// @author "NADIR1"

// Use with MenuManager()
// {{
MF_SEPARATOR = 0x00000800;
MF_ENABLED = 0x00000000;
MF_GRAYED = 0x00000001;
MF_DISABLED = 0x00000002;
MF_UNCHECKED = 0x00000000;
MF_CHECKED = 0x00000008;
MF_STRING = 0x00000000;
AppendTo = 0x00000010;
MF_RIGHTJUSTIFY = 0x00004000;
MF_MENUBARBREAK = 0x00000020;
MF_MENUBREAK = 0x00000040;
// }}
// Used in window.SetCursor()
// {{
IDC_ARROW = 32512;
IDC_IBEAM = 32513;
IDC_WAIT = 32514;
IDC_CROSS = 32515;
IDC_UPARROW = 32516;
IDC_SIZE = 32640;
IDC_ICON = 32641;
IDC_SIZENWSE = 32642;
IDC_SIZENESW = 32643;
IDC_SIZEWE = 32644;
IDC_SIZENS = 32645;
IDC_SIZEALL = 32646;
IDC_NO = 32648;
IDC_APPSTARTING = 32650;
IDC_HAND = 32649;
IDC_HELP = 32651;
// }}
// Use with GdiDrawText()
// {{
DT_TOP = 0x00000000;
DT_LEFT = 0x00000000;
DT_CENTER = 0x00000001;
DT_RIGHT = 0x00000002;
DT_VCENTER = 0x00000004;
DT_BOTTOM = 0x00000008;
DT_WORDBREAK = 0x00000010;
DT_SINGLELINE = 0x00000020;
DT_EXPANDTABS = 0x00000040;
DT_TABSTOP = 0x00000080;
DT_NOCLIP = 0x00000100;
DT_EXTERNALLEADING = 0x00000200;
DT_CALCRECT = 0x00000400; // [1.2.1] Handles well
DT_NOPREFIX = 0x00000800; // NOTE: Please use this flag, or a '&' character will become an underline '_'
DT_INTERNAL = 0x00001000;
DT_EDITCONTROL = 0x00002000;
DT_PATH_ELLIPSIS = 0x00004000;
DT_END_ELLIPSIS = 0x00008000;
DT_MODIFYSTRING = 0x00010000; // do not use
DT_RTLREADING = 0x00020000;
DT_WORD_ELLIPSIS = 0x00040000;
DT_NOFULLWIDTHCHARBREAK = 0x00080000;
DT_HIDEPREFIX = 0x00100000;
DT_PREFIXONLY = 0x00200000;
// }}
// Keyboard Flags & Tools
// {{
VK_BACK = 0x08;
VK_CONTROL = 0x11;
VK_SHIFT = 0x10;
VK_MENU = 0x12; // Alt key
VK_ALT = 0x12;
VK_PAUSE = 0x13;
VK_ESCAPE = 0x1B;
VK_SPACE = 0x20;
VK_DELETE = 0x2E;
VK_PRIOR = 0x21; // PAGE UP key
VK_NEXT = 0x22; // PAGE DOWN key
VK_PGUP = 0x21;
VK_PGDN = 0x22;
VK_END = 0x23;
VK_HOME = 0x24;
VK_LEFT = 0x25;
VK_UP = 0x26;
VK_RIGHT = 0x27;
VK_DOWN = 0x28;
VK_INSERT = 0x2D;
VK_SPACEBAR = 0x20;
VK_RETURN = 0x0D; //Enter
VK_LSHIFT = 0xA0; // Left SHIFT key
VK_RSHIFT = 0xA1; // Right SHIFT key
VK_LCONTROL = 0xA2; // Left CONTROL key
VK_RCONTROL = 0xA3; // Right CONTROL key
VK_LMENU = 0xA4; // Left MENU key
VK_RMENU = 0xA5; // Right MENU key
VK_KEY_0 = 0x30; //	0
VK_KEY_1 = 0x31; //	1
VK_KEY_2 = 0x32; //	2
VK_KEY_3 = 0x33; //	3
VK_KEY_4 = 0x34; //	4
VK_KEY_5 = 0x35; //	5
VK_KEY_6 = 0x36; //	6
VK_KEY_7 = 0x37; //	7
VK_KEY_8 = 0x38; //	8
VK_KEY_9 = 0x39; //	9
VK_KEY_A = 0x41; //	A
VK_KEY_B = 0x42; //	B
VK_KEY_C = 0x43; //	C
VK_KEY_D = 0x44; //	D
VK_KEY_E = 0x45; //	E
VK_KEY_F = 0x46; //	F
VK_KEY_G = 0x47; //	G
VK_KEY_H = 0x48; //	H
VK_KEY_I = 0x49; //	I
VK_KEY_J = 0x4A; //	J
VK_KEY_K = 0x4B; //	K
VK_KEY_L = 0x4C; //	L
VK_KEY_M = 0x4D; //	M
VK_KEY_N = 0x4E; //	N
VK_KEY_O = 0x4F; //	O
VK_KEY_P = 0x50; //	P
VK_KEY_Q = 0x51; //	Q
VK_KEY_R = 0x52; //	R
VK_KEY_S = 0x53; //	S
VK_KEY_T = 0x54; //	T
VK_KEY_U = 0x55; //	U
VK_KEY_V = 0x56; //	V
VK_KEY_W = 0x57; //	W
VK_KEY_X = 0x58; //	X
VK_KEY_Y = 0x59; //	Y
VK_KEY_Z = 0x5A; //	Z
var KMask = {
	none : 0,
	ctrl : 1,
	shift : 2,
	ctrlshift : 3,
	ctrlalt : 4,
	ctrlaltshift : 5,
	alt : 6
};
function GetKeyboardMask() {
	var c = utils.IsKeyPressed(VK_CONTROL) ? true : false;
	var a = utils.IsKeyPressed(VK_ALT) ? true : false;
	var s = utils.IsKeyPressed(VK_SHIFT) ? true : false;
	var ret = KMask.none;
	if (c && !a && !s)
		ret = KMask.ctrl;
	if (!c && !a && s)
		ret = KMask.shift;
	if (c && !a && s)
		ret = KMask.ctrlshift;
	if (c && a && !s)
		ret = KMask.ctrlalt;
	if (c && a && s)
		ret = KMask.ctrlaltshift;
	if (!c && a && !s)
		ret = KMask.alt;
	return ret;
}
// Used in utils.Glob()
// For more information, see: http://msdn.microsoft.com/en-us/library/ee332330%28VS.85%29.aspx
FILE_ATTRIBUTE_READONLY = 0x00000001;
FILE_ATTRIBUTE_HIDDEN = 0x00000002;
FILE_ATTRIBUTE_SYSTEM = 0x00000004;
FILE_ATTRIBUTE_DIRECTORY = 0x00000010;
FILE_ATTRIBUTE_ARCHIVE = 0x00000020;
//FILE_ATTRIBUTE_DEVICE            = 0x00000040; // do not use
FILE_ATTRIBUTE_NORMAL = 0x00000080;
FILE_ATTRIBUTE_TEMPORARY = 0x00000100;
FILE_ATTRIBUTE_SPARSE_FILE = 0x00000200;
FILE_ATTRIBUTE_REPARSE_POINT = 0x00000400;
FILE_ATTRIBUTE_COMPRESSED = 0x00000800;
FILE_ATTRIBUTE_OFFLINE = 0x00001000;
FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = 0x00002000;
FILE_ATTRIBUTE_ENCRYPTED = 0x00004000;
//FILE_ATTRIBUTE_VIRTUAL           = 0x00010000; // do not use
//--->
// With window.DlgCode, can be combined.
// If you don't know what they mean, igonre them.
DLGC_WANTARROWS = 0x0001;
/* Control wants arrow keys         */
DLGC_WANTTAB = 0x0002;
/* Control wants tab keys           */
DLGC_WANTALLKEYS = 0x0004;
/* Control wants all keys           */
DLGC_WANTMESSAGE = 0x0004;
/* Pass message to control          */
DLGC_HASSETSEL = 0x0008;
/* Understands EM_SETSEL message    */
DLGC_DEFPUSHBUTTON = 0x0010;
/* Default pushbutton               */
DLGC_UNDEFPUSHBUTTON = 0x0020;
/* Non-default pushbutton           */
DLGC_RADIOBUTTON = 0x0040;
/* Radio button                     */
DLGC_WANTCHARS = 0x0080;
/* Want WM_CHAR messages            */
DLGC_STATIC = 0x0100;
/* Static item: don't include       */
DLGC_BUTTON = 0x2000;
/* Button item: can be checked      */
//--->
// Used in IFbTooltip.GetDelayTime() and IFbTooltip.SetDelayTime()
// For more information, see: http://msdn.microsoft.com/en-us/library/bb760404(VS.85).aspx
TTDT_AUTOMATIC = 0;
TTDT_RESHOW = 1;
TTDT_AUTOPOP = 2;
TTDT_INITIAL = 3;
//--->
var vb = {};
vb.Function = function (func) {
	return function () {
		return vb.Function.eval.call(this, func, arguments);
	}
};

vb.Function.eval = function (func) {
	var args = Array.prototype.slice.call(arguments[1]);
	for (var i = 0;
		i < args.length;
		i++) {
		if (typeof args[i] != 'string') {
			continue;
		}
		args[i] = '"' + args[i].replace(/"/g, '" + Chr(34) + "') + '"';
	}
	var vbe;
	vbe = new ActiveXObject('ScriptControl');
	vbe.Language = 'VBScript';
	return vbe.eval(func + '(' + args.join(', ') + ')');
};

var InputBox = vb.Function('InputBox');
var MsgBox = vb.Function('MsgBox');
vb.OKOnly = 0;
vb.OKCancel = 1;
vb.AbortRetryIgnore = 2;
vb.YesNoCancel = 3;
vb.YesNo = 4;
vb.RetryCancel = 5;
vb.Critical = 16;
vb.Question = 32;
vb.Exclamation = 48;
vb.Information = 64;
vb.DefaultButton1 = 0;
vb.DefaultButton2 = 256;
vb.DefaultButton3 = 512;
vb.DefaultButton4 = 768;
vb.ApplicationModal = 0;
vb.SystemModal = 4096;
vb.OK = 1;
vb.Cancel = 2;
vb.Abort = 3;
vb.Retry = 4;
vb.Ignore = 5;
vb.Yes = 6;
vb.No = 7;

var FontStyles = {
	Regular : 0,
	Bold : 1,
	Italic : 2,
	BoldItalic : 3,
	Underline : 4,
	Strikeout : 8
};
TextRenderingHint = {
	SystemDefault : 0,
	SingleBitPerPixelGridFit : 1,
	SingleBitPerPixel : 2,
	AntiAliasGridFit : 3,
	AntiAlias : 4,
	ClearTypeGridFit : 5
};
SmoothingMode = {
	Invalid : -1,
	Default : 0,
	HighSpeed : 1,
	HighQuality : 2,
	None : 3,
	AntiAlias : 4
};

AlbumArtId = {
	front : 0,
	back : 1,
	disc : 2,
	icon : 3,
	artist : 4
};

InterpolationMode = {
	Invalid : -1,
	Default : 0,
	LowQuality : 1,
	HighQuality : 2,
	Bilinear : 3,
	Bicubic : 4,
	NearestNeighbor : 5,
	HighQualityBilinear : 6,
	HighQualityBicubic : 7
};

playbackOrder = {
	Default : 0,
	RepeatPlaylist : 1,
	RepeatTrack : 2,
	Random : 3,
	ShuffleTracks : 4,
	ShuffleAlbums : 5,
	ShuffleFolders : 6
};

// {{
// Used in gr.DrawString()
function StringFormat() {
	var h_align = 0,
	v_align = 0,
	trimming = 0,
	flags = 0;
	switch (arguments.length) {
	case 4:
		flags = arguments[3];
	case 3:
		trimming = arguments[2];
	case 2:
		v_align = arguments[1];
	case 1:
		h_align = arguments[0];
		break;
	default:
		return 0;
	}
	return ((h_align << 28) | (v_align << 24) | (trimming << 20) | flags);
}
StringAlignment = {
	Near : 0,
	Centre : 1,
	Far : 2,
	NoWrap : 1
};
var l_stringformat = StringFormat(StringAlignment.Near, StringAlignment.Centre, StringAlignment.NoWrap);
var lt_stringformat = StringFormat(StringAlignment.Near, StringAlignment.Near, StringAlignment.NoWrap);
var ct_stringformat = StringFormat(StringAlignment.Centre, StringAlignment.Near);
var rt_stringformat = StringFormat(StringAlignment.Far, StringAlignment.Near);
var lc_stringformat = StringFormat(StringAlignment.Near, StringAlignment.Centre);
var cc_stringformat = StringFormat(StringAlignment.Centre, StringAlignment.Centre);
var rc_stringformat = StringFormat(StringAlignment.Far, StringAlignment.Centre);
var lb_stringformat = StringFormat(StringAlignment.Near, StringAlignment.Far);
var cb_stringformat = StringFormat(StringAlignment.Centre, StringAlignment.Far);
var rb_stringformat = StringFormat(StringAlignment.Far, StringAlignment.Far);
//}}
// {{
// Used in utils.GetAlbumArt()
AlbumArtId = {
	front : 0,
	back : 1,
	disc : 2,
	icon : 3,
	artist : 4
};
//}}
// {{
// Used everywhere!
function RGB(r, g, b) {
	return (0xff000000 | (r << 16) | (g << 8) | (b));
}
function RGBA(r, g, b, a) {
	return ((a << 24) | (r << 16) | (g << 8) | (b));
}
function getAlpha(color) {
	return ((color >> 24) & 0xff);
}
function setAlpha(color, a) {
	return ((color & 0x00ffffff) | (a << 24));
}
function getRed(color) {
	return ((color >> 16) & 0xff);
}
function getGreen(color) {
	return ((color >> 8) & 0xff);
}
function getBlue(color) {
	return (color & 0xff);
}
function negative(colour) {
	var R = getRed(colour);
	var G = getGreen(colour);
	var B = getBlue(colour);
	return RGB(Math.abs(R - 255), Math.abs(G - 255), Math.abs(B - 255));
}
function toRGB(d) { // convert back to RGB values
	var d = d - 0xff000000;
	var r = d >> 16;
	var g = d >> 8 & 0xFF;
	var b = d & 0xFF;
	return [r, g, b];
}
function blendColors(c1, c2, factor) {
	// When factor is 0, result is 100% color1, when factor is 1, result is 100% color2.
	var c1 = toRGB(c1);
	var c2 = toRGB(c2);
	var r = Math.round(c1[0] + factor * (c2[0] - c1[0]));
	var g = Math.round(c1[1] + factor * (c2[1] - c1[1]));
	var b = Math.round(c1[2] + factor * (c2[2] - c1[2]));
	//fb.trace("R = " + r + " G = " + g + " B = " + b);
	return (0xff000000 | (r << 16) | (g << 8) | (b));
}
function num(strg, nb) {
	var i;
	var str = strg.toString();
	var k = nb - str.length;
	if (k > 0) {
		for (i = 0; i < k; i++) {
			str = "0" + str;
		}
	}
	return str.toString();
}

var g_syscolor = 0;
var COLOR_BTNFACE = 15;

function get_syscolors() {
	g_syscolor = utils.GetSysColor(COLOR_BTNFACE);
}
get_syscolors();

function TrackType(trkpath) {
	var taggable;
	var type;
	switch (trkpath) {
	case "file":
		taggable = 1;
		type = 0;
		break;
	case "cdda":
		taggable = 1;
		type = 1;
		break;
	case "FOO_":
		taggable = 0;
		type = 2;
		break;
	case "http":
		taggable = 0;
		type = 3;
		break;
	case "mms:":
		taggable = 0;
		type = 3;
		break;
	case "unpa":
		taggable = 0;
		type = 4;
		break;
	default:
		taggable = 0;
		type = 5;
	};
	return type;
};
function replaceAll(str, search, repl) {
	while (str.indexOf(search) != -1) {
		str = str.replace(search, repl);
	};
	return str;
};
function removeAccents(str) {
	/*
	var norm = new Array('','','?','?','?','?','?','?','','','','?',
	'','','?','?', 'D','?','','','?','?','?','?','','','?','','Y',
	'T','?');
	var spec = new Array('A','A','A','A','A','A','AE','C','E','E','E','E',
	'I','I','I','I', 'D','N','O','O','O','O','O','O','U','U','U','U','Y',
	'b','SS');
	for (var i = 0; i < spec.length; i++) {
	str = replaceAll(str, norm[i], spec[i]);
	};
	 */
	return str;
};
//}}

// Button object
ButtonStates = {
	normal : 0,
	hover : 1,
	down : 2
};
button = function (normal, hover, down) {
	this.img = Array(normal, hover, down);
	this.w = this.img[0].Width;
	this.h = this.img[0].Height;
	this.state = ButtonStates.normal;
	this.update = function (normal, hover, down) {
		this.img = Array(normal, hover, down);
		this.repaint();
	}
	this.draw = function (gr, x, y, alpha) {
		this.x = x;
		this.y = y;
		this.img[this.state] && gr.DrawImage(this.img[this.state], this.x, this.y, this.w, this.h, 0, 0, this.w, this.h, 0, alpha);
	}
	this.display_context_menu = function (x, y, id) {};
	this.repaint = function () {
		window.RepaintRect(this.x, this.y, this.w, this.h);
	}
	this.checkstate = function (event, x, y) {
		this.ishover = (x > this.x && x < this.x + this.w - 1 && y > this.y && y < this.y + this.h - 1);
		this.old = this.state;
		switch (event) {
		case "down":
			switch (this.state) {
			case ButtonStates.normal:
			case ButtonStates.hover:
				this.state = this.ishover ? ButtonStates.down : ButtonStates.normal;
				break;
			};
			break;
		case "up":
			this.state = this.ishover ? ButtonStates.hover : ButtonStates.normal;
			break;
		case "right":
			if (this.ishover)
				this.display_context_menu(x, y, id);
			break;
		case "move":
			switch (this.state) {
			case ButtonStates.normal:
			case ButtonStates.hover:
				this.state = this.ishover ? ButtonStates.hover : ButtonStates.normal;
				break;
			};
			break;
		case "leave":
			this.state = this.isdown ? ButtonStates.down : ButtonStates.normal;
			break;
		}
		if (this.state != this.old)
			this.repaint();
		return this.state;
	}
}
function TimeFmt(t) {
	var zpad = function (n) {
		var str = n.toString();
		return (str.length < 2) ? "0" + str : str;
	}
	var h = Math.floor(t / 3600);
	t -= h * 3600;
	var m = Math.floor(t / 60);
	t -= m * 60;
	var s = Math.floor(t);
	if (h > 0)
		return h.toString() + ":" + zpad(m) + ":" + zpad(s);
	return m.toString() + ":" + zpad(s);
}

function Format_hms(t, len) {
	if (t) {
		switch (len) {
		case 4:
			var hms = t;
			break;
		case 5:
			switch (t.length) {
			case 4:
				var hms = "0" + t;
				break;
			case 5:
				var hms = t;
				break;
			}
			break;
		case 7:
			switch (t.length) {
			case 4:
				var hms = "0:0" + t;
				break;
			case 5:
				var hms = "0:" + t;
				break;
			case 7:
				var hms = t;
				break;
			}
			break;
		case 8:
			switch (t.length) {
			case 4:
				var hms = "00:0" + t;
				break;
			case 5:
				var hms = "00:" + t;
				break;
			case 7:
				var hms = "0" + t;
				break;
			case 8:
				var hms = t;
				break;
			}
			break;
		}
	} else {
		switch (len) {
		case 4:
			var hms = "0:00";
			break;
		case 5:
			var hms = "00:00";
			break;
		case 7:
			var hms = "0:00:00";
			break;
		case 8:
			var hms = "00:00:00";
			break;
		}
	}
	return hms;
}

draw_image = function (gr, img, pos_x, pos_y, width, height, type, interpolation_mode, border, alpha) {
	if (!img)
		return;
	gr.SetInterpolationMode(interpolation_mode);
	if (width > 0 && height > 0) {
		switch (type) {
		case "crop":
		case "crop top":
		case "crop bottom":
			var sr = img.Width / img.Height;
			var dr = width / height;
			if (sr < dr) {
				var r = img.Width / width;
				var ch = height * r;
				var sy = type == "crop top" ? 0 : type == "crop bottom" ? Math.round(img.Height - ch) : Math.round((img.Height - ch) / 2);
				var cw = img.Width;
				var sx = 0;
			} else {
				var r = img.Height / height;
				var cw = width * r;
				var sx = Math.round((img.Width - cw) / 2);
				var ch = img.Height;
				var sy = 0;
			}
			gr.DrawImage(img, pos_x, pos_y, width, height, sx, sy, cw, ch, 0, alpha || 255);
			if (border)
				gr.DrawRect(pos_x, pos_y, width - 1, height - 1, 1, border);
			break;
		case "stretch":
			gr.DrawImage(img, pos_x, pos_y, width, height, 0, 0, img.Width, img.Height, 0, alpha || 255);
			if (border)
				gr.DrawRect(pos_x, pos_y, width - 1, height - 1, 1, border);
			break;
		case "centre":
		default:
			var s = Math.min(width / img.Width, height / img.Height);
			var nw = Math.round(img.Width * s);
			var nh = Math.round(img.Height * s);
			pos_x += Math.round((width - nw) / 2);
			pos_y += Math.round((height - nh) / 2);
			gr.DrawImage(img, pos_x, pos_y, nw, nh, 0, 0, img.Width, img.Height, 0, alpha || 255);
			if (border)
				gr.DrawRect(pos_x, pos_y, nw - 1, nh - 1, 1, border);
			break;
		}
	}
}

function isPlaylistPresent(name) {
	for (var i = 0; i < plman.PlaylistCount; i++) {
		if (plman.GetPlaylistName(i) == name) {
			return i;
		}
	}
	return -1;
}

function ShowPlaylistQueue(focus_id) {
	var total_pl = plman.PlaylistCount;
	var queue_pl_idx = isPlaylistPresent("Queue Content");
	if (queue_pl_idx < 0) {
		plman.CreatePlaylist(total_pl, "Queue Content");
		queue_pl_idx = total_pl;
		plman.ActivePlaylist = queue_pl_idx;
	} else {
		plman.ActivePlaylist = queue_pl_idx;
		fb.ClearPlaylist();
	};
	var queue_total = plman.GetPlaybackQueueCount();
	var vbarr = plman.GetPlaybackQueueContents();
	var arr = vbarr.toArray();
	var q_handlelist = plman.GetPlaylistSelectedItems(queue_pl_idx);
	q_handlelist.RemoveAll();
	for (var i = 0; i < queue_total; i++) {
		q_handlelist.Add(arr[i].Handle);
	};
	plman.InsertPlaylistItems(queue_pl_idx, i, q_handlelist, false);
	plman.SetPlaylistFocusItem(queue_pl_idx, focus_id);
}

function ShowNowPlaying() {
	if (fb.IsPlaying) {
		if (plman.PlayingPlaylist != plman.ActivePlaylist) {
			plman.ActivePlaylist = plman.PlayingPlaylist;
		}
		if (plman.PlaylistItemCount(plman.PlayingPlaylist) == 0 || !fb.GetFocusItem(false)) {
			return true;
		}
		plman.ClearPlaylistSelection(plman.ActivePlaylist);
		var nowplaying = plman.GetPlayingItemLocation();
		var pid = nowplaying.PlaylistItemIndex;
		plman.SetPlaylistFocusItem(plman.ActivePlaylist, pid);
		plman.SetPlaylistSelectionSingle(plman.ActivePlaylist, pid, true);
	}
}

function RenamePL(idx) {
	plman.ActivePlaylist = idx;
	fb.RunMainMenuCommand("ļ/б");
}

function Menu_Menu(x, y) {

	var a = window.CreatePopupMenu();
	var b = fb.CreateContextMenuManager();

	b.InitNowPlaying();

	var c1 = window.CreatePopupMenu();
	var c2 = window.CreatePopupMenu();
	var c3 = window.CreatePopupMenu();
	var c4 = window.CreatePopupMenu();
	var c5 = window.CreatePopupMenu();
	var c6 = window.CreatePopupMenu();
	var c7 = window.CreatePopupMenu();

	var d1 = fb.CreateMainMenuManager();
	var d2 = fb.CreateMainMenuManager();
	var d3 = fb.CreateMainMenuManager();
	var d4 = fb.CreateMainMenuManager();
	var d5 = fb.CreateMainMenuManager();
	var d6 = fb.CreateMainMenuManager();

	c1.AppendTo(a, 0, "ļ");
	c2.AppendTo(a, 0, "༭");
	c3.AppendTo(a, 0, "ͼ");
	c4.AppendTo(a, 0, "");
	c5.AppendTo(a, 0, "ý");
	c6.AppendTo(a, 0, "");
	fb.IsPlaying && a.AppendMenuItem(2048, 0, 0);
	fb.IsPlaying && c7.AppendTo(a, 0, "ڲ");

	if (utils.IsKeyPressed(VK_SHIFT)) {
		a.AppendMenuSeparator();
		a.AppendMenuItem(MF_STRING, 1501, "");
		a.AppendMenuItem(MF_STRING, 1502, "");
	}

	d1.Init("file");
	d2.Init("edit");
	d3.Init("View");
	d4.Init("playback");
	d5.Init("library");
	d6.Init("help");

	d1.BuildMenu(c1, 1, 200);
	d2.BuildMenu(c2, 201, 200);
	d3.BuildMenu(c3, 401, 200);
	d4.BuildMenu(c4, 601, 300);
	d5.BuildMenu(c5, 901, 300);
	d6.BuildMenu(c6, 1201, 100);

	b.InitNowPlaying();
	b.BuildMenu(c7, 1301, -1);
	ret = 0;

	ret = a.TrackPopupMenu(x, y);
	switch (true) {

	case (ret >= 1 && ret < 201):
		d1.ExecuteByID(ret - 1);
		break;
	case (ret >= 201 && ret < 401):
		d2.ExecuteByID(ret - 201);
		break;
	case (ret >= 401 && ret < 601):
		d3.ExecuteByID(ret - 401);
		break;
	case (ret >= 601 && ret < 901):
		d4.ExecuteByID(ret - 601);
		break;
	case (ret >= 901 && ret < 1201):
		d5.ExecuteByID(ret - 901);
		break;
	case (ret >= 1201 && ret < 1301):
		d6.ExecuteByID(ret - 1201);
		break;
	case (ret >= 1301 && ret < 1501):
		b.ExecuteByID(ret - 1301);
		break;

	}

	switch (ret) {
	case 1501:
		window.ShowProperties();
		break;
	case 1502:
		window.ShowConfigure();
		break;
	}

	a.Dispose();
	b.Dispose();
	d1.Dispose();
	d2.Dispose();
	d3.Dispose();
	d4.Dispose();
	d5.Dispose();
	d6.Dispose();
	return true
}

// ================================================================================= //
var safeMode = false;

try {
	WshShell = new ActiveXObject("WScript.Shell");
	doc = new ActiveXObject("htmlfile");
} catch (e) {
	fb.trace("----------------------------------------------------------------------");
	fb.trace(e + "\n: ڲѡ >  > WSH ǿнðȫģʽ");
	fb.trace("----------------------------------------------------------------------");
	safeMode = true;
}

// ================================================================================= //


function print(msg) {
	fb.trace("---> " + msg);
}

function caller() {
	var caller = /^function\s+([^(]+)/.exec(arguments.callee.caller.caller);
	if (caller)
		return caller[1];
	else
		return 0;
}

function $(field, metadb) {
	var tf;
	try {
		tf = fb.TitleFormat(field).EvalWithMetadb(metadb);
	} catch (e) {
		tf = e + " (Invalid metadb!)"
	};
	return tf;
}

(function () {

	var _ww,
	_resizeTimerStarted;

	isResizingDone = function (ww, wh) {

		if (!_resizeTimerStarted) {

			_resizeTimerStarted = true;
			resizingIsDone = false;

			resizeTimer = window.SetInterval(function () {

					if (_ww == window.Width) {

						resizeDone();

						resizingIsDone = true;

						_resizeTimerStarted = false;

						window.ClearInterval(resizeTimer);

					}

				}, 200);

		}
		_ww = ww;
	}
})();

function numericAscending(a, b) {

	return (a - b);

}

function numericDescending(a, b) {

	return (b - a);

}
//ע
var g_backcolor = RGB(255, 255, 255);
var g_textcolor = RGB(50, 50, 50);
var g_textcolor_2 = RGB(68, 68, 68);

var g_select_txt_col;
var g_select_bg_col;
var fa_g_normal_txt_col;
var fa_g_select_alpha;

function setColor(refresh) {

	custom_select_txtcol = window.GetProperty("Color.Selected.txt", "RGB(255, 255, 255)");
	custom_select_bgcol = window.GetProperty("Color.Selected.bg", "RGB(86, 86, 86)");
	fa_custom_normal_txtcol = window.GetProperty("fa_Color.Normal.txt", "RGB(68, 68, 68)");
	fa_custom_select_alpha = window.GetProperty("fa_Color.Selected.alpha", "200");

	g_select_txt_col = eval(custom_select_txtcol);
	g_select_bg_col = eval(custom_select_bgcol);
	fa_g_normal_txt_col = eval(fa_custom_normal_txtcol);
	fa_g_select_alpha = eval(fa_custom_select_alpha);

	if (refresh)
		on_size();

}
setColor(false);
